
<script src="assets/libs/jquery/jquery-3.7.1.min.js"></script>
<!-- <script src="assets/libs/typeahead/typeahead-v4.0.2.min.js"></script> -->
<script>

	const baseUrl = "<?= base_url() ?>"
	const app = {
		hasNext: false,
		pagination: {
			limit: 10,
			start: 0,
			keyword: '',
		}
	}

	$(document).ready(function(){
		loadBrand()	
	})

	function loadBrand()
	{
		$.ajax({
			url: baseUrl+"wellcome-screen/getData",
			method: 'post',
			dataType: 'json',
			contentType: 'application/json',
			data: JSON.stringify(app.pagination),
			success: respon => {
				if(respon?.success){

					if ($("#container").find(".loading-md").length > 0) {

						$("#container").html('')
					}

					if ($("#container").find(".loading-sm").length > 0) {

						$("#container").find('.loading-sm').remove()
					}

					if(respon.data.data.length>0){
						respon.data.data.forEach(item => {
							$("#container").append(showItem(item))
						})
					}else{
						showEmptyIcon(true)
					}

					app.hasNext = respon.data.hasNext

				}
			},
			error: () => {

			}
		})
	}


	const debouncedSearch = debounce((event) => {

	  app.pagination.start = 0
	  app.pagination.keyword = $("#search-input").val()
	  showMitraLoading(true)
	  loadBrand()
	}, 512);

	$("#search-input").on('input',debouncedSearch)

	function debounce(func, delay) {
	  let timeoutId;
	  return function(...args) {
	      clearTimeout(timeoutId);
	      timeoutId = setTimeout(() => func(...args), delay);
	  };
	}


	$(window).scroll(function() {
	  if($(window).scrollTop() + $(window).height() >= $(document).height()-3){
	    if (app.hasNext) {
	    	app.hasNext=false
	      	showLoadingNextLoad(true)

	      	app.pagination.start += app.pagination.limit
	      	loadBrand()
	    }
	    
	  }
	});


	function showItem({logo,name,tagline,position})
	{
		return `<div class="col-span-6 shadow-md drop-shadow-md rounded-md flex justify-center items-center flex-col py-4">
						<div class="w-[8rem] h-[7rem]">
							<img src="<?= base_url() ?>uploads/brand/logo/${logo}" class="w-full h-full" onerror="this.onerror=null; this.src='https://placehold.co/120'">
						</div>
						<span class="font-bold text-[8px] text-center mt-3 Montserrat">${name}</span>
						<span class=" text-[8px] text-center Montserrat">${tagline}</span>
						<span class="font-bold text-[6px] text-center Montserrat">${position}</span>
					</div>`
	}

	function showMitraLoading(isTrue)
	{
		if(isTrue){
			$("#container").html(`<div class="loading-md col-span-12 flex justify-center py-2 mt-5">
				<div>
					<div class="loader"></div>
				</div>
			</div>`)
		}
	}

	function showLoadingNextLoad(isTrue)
	{
		if(isTrue){
			$("#container").append(`<div class="loading-sm col-span-12 flex justify-center flex-col items-center py-5">
				<div class="loading-dots">
				    <span></span>
				    <span></span>
				    <span></span>
				</div>
			</div>`)
		}
	}

	function showEmptyIcon(isTrue)
	{
		if(isTrue){
			$("#container").html(`<div class="col-span-12 flex justify-center flex-col items-center pt-5">
						<img src="<?= base_url() ?>assets/images/empty-folder.svg">
						<span class="text-center text-sm text-[#c40c0c] font-medium">Brand yang anda cari di temukan</span>
					</div>`)
		}
	}
</script>