<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */


$routes->group('auth', function($routes) {
    $routes->match(['get', 'post'], '/', 'Auth::index');
    $routes->match(['get', 'post'], 'login', 'Auth::login');
    $routes->match(['get', 'post'], 'logout', 'Auth::logout');
});

$routes->get('/', 'Home::index');
$routes->match(['get', 'post'], 'get-', 'Dashboard::index');


$routes->group('dashboard', function($routes) {
    $routes->match(['get', 'post'], '/', 'Dashboard::index');
    $routes->get('machine', 'Dashboard::getDetailMachine'); 
    $routes->match(['get', 'post'], 'save-goal', 'Dashboard::save');
    $routes->match(['get', 'post'], 'all-information', 'Dashboard::allInformation');
    $routes->match(['get', 'post'], 'export', 'Dashboard::export');
    $routes->match(['get', 'post'], 'reset', 'Dashboard::reset');
});


$routes->group('api/v1', function($routes) {
    $routes->post('machine', 'api\v1\Machine::set'); 
    $routes->post('reset', 'api\v1\Machine::reset');
    $routes->match(['get', 'post'], 'cronjob-check', 'api\v1\Machine::check');
    $routes->match(['get', 'post'], 'cronjob-dayily', 'api\v1\Machine::dayily');
});




